### Name: readOGR
### Title: Read OGR vector maps into Spatial objects
### Aliases: readOGR ogrInfo print.ogrinfo ogrFIDs ogrDrivers
### Keywords: spatial

### ** Examples

ogrDrivers()
ogrInfo(system.file("vectors", package = "rgdal")[1], "cities")
cities <- readOGR(system.file("vectors", package = "rgdal")[1], "cities")
summary(cities)
ogrInfo(system.file("vectors", package = "rgdal")[1], "kiritimati_primary_roads")
kiritimati_primary_roads <- readOGR(system.file("vectors", package = "rgdal")[1], "kiritimati_primary_roads")
summary(kiritimati_primary_roads)
ogrInfo(system.file("vectors", package = "rgdal")[1], "scot_BNG")
scot_BNG <- readOGR(system.file("vectors", package = "rgdal")[1], "scot_BNG")
summary(scot_BNG)
if ("GML" %in% ogrDrivers()$name) {
  airports <- try(readOGR(system.file("vectors/airports.gml", package = "rgdal")[1], "airports"))
  if (class(airports) != "try-error") summary(airports)
}
ogrInfo(system.file("vectors/ps_cant_31.MIF", package = "rgdal")[1], "ps_cant_31")
ps_cant_31 <- readOGR(system.file("vectors/ps_cant_31.MIF", package = "rgdal")[1], "ps_cant_31")
summary(ps_cant_31)
ogrInfo(system.file("vectors/Up.tab", package = "rgdal")[1], "Up")
Up <- readOGR(system.file("vectors/Up.tab", package = "rgdal")[1], "Up")
summary(Up)
test_trk2 <- try(readOGR(system.file("vectors/test_trk2.gpx", package = "rgdal")[1], "tracks"))
if (class(test_trk2) != "try-error") summary(test_trk2)
test_trk2pts <- try(readOGR(system.file("vectors/test_trk2.gpx", package = "rgdal")[1], "track_points"))
if (class(test_trk2pts) != "try-error") summary(test_trk2pts)
ogrInfo(system.file("vectors", package = "rgdal")[1], "trin_inca_pl03")
birds <- readOGR(system.file("vectors", package = "rgdal")[1], "trin_inca_pl03")
summary(birds)



