#############################################################################
#
# MODULE:   	Grass Compilation
# AUTHOR(S):	Original author unknown - probably CERL
#		Markus Neteler - Germany/Italy - neteler@itc.it
#   	    	Justin Hickey - Thailand - jhickey@hpcc.nectec.or.th
#   	    	Huidae Cho - Korea - grass4u@gmail.com
#   	    	Eric G. Miller - egm2@jps.net
# PURPOSE:  	The source file for this Makefile is in src/CMD/head/head.in.
#		It is the top part of a file called make.rules which is used
#		for compiling all GRASS modules. This part of the file provides
#		make variables that are dependent on the results of the
#		configure script.
# COPYRIGHT:    (C) 2000 by the GRASS Development Team
#
#               This program is free software under the GNU General Public
#   	    	License (>=v2). Read the file COPYING that comes with GRASS
#   	    	for details.
#
#############################################################################

############################## Make Variables ###############################

CC                  = gcc
#FC                  = @F77@
CXX                 = c++
LEX                 = flex
YACC                = bison -y
PERL                = /usr/bin/perl
AR                  = ar
RANLIB              = ranlib
MKDIR               = mkdir -p
CHMOD               = chmod
INSTALL             = /usr/bin/install -c 
INSTALL_DATA        = ${INSTALL} -m 644

prefix              = /Applications
exec_prefix         = ${prefix}
ARCH                = i686-apple-darwin9.2.2
UNIX_BIN            = ${exec_prefix}/bin
INST_DIR            = ${prefix}/GRASS-6.3.app/Contents/MacOS

PLAT_OBJS           = 
STRIPFLAG           = 
CC_SEARCH_FLAGS     = 
LD_SEARCH_FLAGS     = 
LD_LIBRARY_PATH_VAR = DYLD_LIBRARY_PATH
LIB_RUNTIME_DIR     = $(ARCH_LIBDIR)

#static libs:
STLIB_LD            = ${AR} cr
STLIB_PREFIX        = lib
STLIB_SUFFIX        = .a

#shared libs
SHLIB_PREFIX        = lib
SHLIB_LD            = cc -dynamiclib -compatibility_version ${GRASS_VERSION_MAJOR}.${GRASS_VERSION_MINOR} -current_version ${GRASS_VERSION_MAJOR}.${GRASS_VERSION_MINOR} -install_name ${INST_DIR}/lib/lib${LIB_NAME}${SHLIB_SUFFIX}
SHLIB_LD_EXTRAS     = 
SHLIB_LD_FLAGS      = 
SHLIB_LD_LIBS       = ${LIBS}
SHLIB_CFLAGS        = -fno-common
SHLIB_SUFFIX        = .dylib
EXE                 = 


# GRASS dirs
GRASS_HOME = $(GRASS_HOME)
RUN_GISBASE = $(GISBASE)
RUN_GISRC           = ${ARCH_DISTDIR}/demolocation/.grassrc${GRASS_VERSION_MAJOR}${GRASS_VERSION_MINOR}

DEFAULT_DATABASE    =
DEFAULT_LOCATION    =

CPPFLAGS            = 
CFLAGS1             = -Os -arch ppc -arch i386 
CXXFLAGS1           = -Os -arch ppc -arch i386
INCLUDE_DIRS        = 

COMPILE_FLAGS       = $(CPPFLAGS) $(CFLAGS1) $(INCLUDE_DIRS)
COMPILE_FLAGS_CXX   = $(CPPFLAGS) $(CXXFLAGS1) $(INCLUDE_DIRS)
LINK_FLAGS          = -arch ppc -arch i386 -arch ppc -arch i386

DLLIB               = 
XCFLAGS             =  -I/usr/X11/include
XMINC               = 
XLIBPATH            =  -L/usr/X11/lib
XLIB                =  -lSM -lICE -lX11
XTLIB               = -lXt
XMLIB               = 
XEXTRALIBS          = 
USE_X11             = 1

COMPATLIB           = 
CURSES              = -lncurses $(COMPATLIB)
USE_CURSES          = 1
MATHLIB             =  
XDRLIB              =     -lz 
ICONVLIB            = -liconv
INTLLIB             = 
SOCKLIB             = 

#ZLIB:
ZLIB                =    -lz 
ZLIBINCPATH         = 
ZLIBLIBPATH         = 

#DBM:
#DBMINCPATH          = @DBMINCPATH@
#DBMLIBPATH          = @DBMLIBPATH@
#DBMLIB              = @DBMLIB@
DBMIEXTRALIB        = 

#readline
READLINEINCPATH     = 
READLINELIBPATH     = 
READLINELIB         =  -lreadline 
HISTORYLIB          =  -ledit 

#PostgreSQL:
PQINCPATH           =  -I/usr/local/pgsql/include
PQLIBPATH           =  -L/usr/local/pgsql/lib
PQLIB               =  -lpq 

#MySQL:
MYSQLINCPATH        =  -I/Users/Shared/unix/mysql-leo/include/mysql
MYSQLLIBPATH        =  -L/Users/Shared/unix/mysql-leo/lib/mysql
MYSQLLIB            =  -lmysqlclient -lssl -lcrypto -lz
MYSQLDLIB            = -L/Users/Shared/unix/mysql-leo/lib/mysql -lmysqld -lz -lm -lssl -lcrypto -lstdc++

#SQLite:
SQLITEINCPATH        =  -I/Library/Frameworks/SQLite3.framework/unix/include
SQLITELIBPATH        =  -L/Library/Frameworks/SQLite3.framework/unix/lib
SQLITELIB            =  -lsqlite3 

#FFMPEG
FFMPEGINCPATH        =  -I/Users/Shared/unix/ffmpeg-leo/include/ffmpeg
FFMPEGLIBPATH        =  -L/Users/Shared/unix/ffmpeg-leo/lib
FFMPEGLIB            =  -lavcodec -lavutil  -lavformat 

#ODBC:
ODBCINC             = 
ODBCLIB             =  -liodbc 

#Image formats:
PNGINC              =  -I/Library/Frameworks/UnixImageIO.framework/unix/include
PNGLIB              =  -L/Library/Frameworks/UnixImageIO.framework/unix/lib -lpng  -lz  
USE_PNG             = 1

JPEGINCPATH         =  -I/Library/Frameworks/UnixImageIO.framework/unix/include
JPEGLIBPATH         =  -L/Library/Frameworks/UnixImageIO.framework/unix/lib
JPEGLIB             =  -ljpeg 

TIFFINCPATH         =  -I/Library/Frameworks/UnixImageIO.framework/unix/include
TIFFLIBPATH         =  -L/Library/Frameworks/UnixImageIO.framework/unix/lib
TIFFLIB             =  -ltiff 

#openGL files for NVIZ/r3.showdspf
OPENGLINC           = 
OPENGLWINC          = 
OPENGLLIB           =  -L/usr/X11/lib  -lGL 
OPENGLULIB          =  -L/usr/X11/lib  -lGLU 
OPENGLWM            = 
#USE_GLWM            = @USE_GLWM@
OPENGL_X11          = 1
OPENGL_AQUA         = 
OPENGL_WINDOWS      = 

#tcl/tk stuff
TCLINCDIR           =  -I/Users/Shared/unix/tcltk-leo32/include
TKINCDIR            =  -I/Users/Shared/unix/tcltk-leo32/include
TCLTKLIBPATH        =  -L/Users/Shared/unix/tcltk-leo32/lib
TCLTKLIBS           =  -ltk   -ltcl 

#FFTW:
FFTWINC             =  -I/Library/Frameworks/FFTW3.framework/unix/include
FFTWLIB             =  -L/Library/Frameworks/FFTW3.framework/unix/lib -lfftw3 

#LAPACK/BLAS stuff for gmath lib:
BLASLIB             = -lblas
BLASINC				=  -I/System/Library/Frameworks/Accelerate.framework/Frameworks/vecLib.framework/Headers
LAPACKLIB           =  -llapack 
LAPACKINC			=  -I/System/Library/Frameworks/Accelerate.framework/Frameworks/vecLib.framework/Headers

#GDAL/OGR
GDALLIBS            = -L/Library/Frameworks/GDAL.framework/Versions/1.5/unix/lib -lgdal
GDALCFLAGS          = -I/Library/Frameworks/GDAL.framework/Versions/1.5/Headers
USE_GDAL            = 1
USE_OGR             = 1

#FreeType:
FTINC               =  -I/Library/Frameworks/FreeType.framework/unix/include/freetype2 -I/Library/Frameworks/FreeType.framework/unix/include
FTLIB               =  -L/Library/Frameworks/FreeType.framework/unix/lib -lfreetype 

#PROJ.4:
PROJINC             =  -I/Library/Frameworks/PROJ.framework/unix/include $(GDALCFLAGS)
PROJLIB             =  -L/Library/Frameworks/PROJ.framework/unix/lib -lproj 
NAD2BIN             = /Library/Frameworks/PROJ.framework/Programs/nad2bin
PROJSHARE           = /Library/Frameworks/PROJ.framework/Resources/proj

#OPENDWG:
OPENDWGINCPATH      = 
OPENDWGLIBPATH      = 
OPENDWGLIB          = 
USE_OPENDWG         = 

#Python
PYTHONINC           = -I/System/Library/Frameworks/Python.framework/Versions/2.5/include/python2.5 -I/System/Library/Frameworks/Python.framework/Versions/2.5/include/python2.5
PYTHONCFLAGS        = -I/System/Library/Frameworks/Python.framework/Versions/2.5/include/python2.5 -I/System/Library/Frameworks/Python.framework/Versions/2.5/include/python2.5 -fno-strict-aliasing -Wno-long-double -no-cpp-precomp -mno-fused-madd -fno-common -dynamic -DNDEBUG -g -Os -Wall -Wstrict-prototypes -DMACOSX -I/usr/include/ffi -DENABLE_DTRACE
PYTHONLDFLAGS       = -L/System/Library/Frameworks/Python.framework/Versions/2.5/lib/python2.5/config -ldl -lpython2.5
SWIG                = /usr/bin/swig
USE_PYTHON          = 1

#wxWidgets
WXVERSION           = 2.8.4
WXWIDGETSCXXFLAGS   = -I/usr/lib/wx/include/mac-unicode-debug-2.8 -I/usr/include/wx-2.8 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILES -D__WXDEBUG__ -D__WXMAC__ 
WXWIDGETSCPPFLAGS   = -I/usr/lib/wx/include/mac-unicode-debug-2.8 -I/usr/include/wx-2.8 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILES -D__WXDEBUG__ -D__WXMAC__
WXWIDGETSLIB        =              -framework QuickTime -framework IOKit -framework Carbon -framework Cocoa -framework System  -lwx_macud-2.8 
USE_WXWIDGETS       = 1

#i18N
HAVE_NLS            = 

#Large File Support (LFS)
USE_LARGEFILES      = 1

#BSD sockets
HAVE_SOCKET         = 1

MINGW		    = 
MACOSX_APP	    = 1

# Cross compilation
CROSS_COMPILING =  
