### Name: readOGR
### Title: Read OGR vector maps into Spatial objects
### Aliases: readOGR ogrInfo print.ogrinfo ogrFIDs ogrDrivers
### Keywords: spatial

### ** Examples

ogrDrivers()
cities <- readOGR(system.file("vectors", package = "rgdal")[1], "cities")
summary(cities)
ogrInfo(system.file("vectors", package = "rgdal")[1], "cities")
kiritimati_primary_roads <- readOGR(system.file("vectors", package = "rgdal")[1], "kiritimati_primary_roads")
summary(kiritimati_primary_roads)
scot_BNG <- readOGR(system.file("vectors", package = "rgdal")[1], "scot_BNG")
summary(scot_BNG)
if ("GML" %in% ogrDrivers()$name) {
  airports <- try(readOGR(system.file("vectors/airports.gml", package = "rgdal")[1], "airports"))
  if (class(airports) != "try-error") summary(airports)
}
ps_cant_31 <- readOGR(system.file("vectors/ps_cant_31.MIF", package = "rgdal")[1], "ps_cant_31")
summary(ps_cant_31)
Up <- readOGR(system.file("vectors/Up.tab", package = "rgdal")[1], "Up")
summary(Up)



